<?php
// Test script for task limits functionality in complete_task.php
require_once 'config.php';

// Test data
$user_id = 1; // Replace with actual user ID
$device_id = 'test_device_123'; // Replace with actual device ID
$session_token = 'test_session_token'; // Replace with actual session token

echo "=== Testing Task Limits in complete_task.php ===\n\n";

// Test Case 1: Complete quiz task (should work and show remaining limit)
echo "Test Case 1: Complete quiz task (LIMITED)\n";
$request_data_1 = [
    'user_id' => $user_id,
    'earned_coins' => 10,
    'by_task' => 'quiz'
];

$encrypted_payload_1 = encryptToken(json_encode($request_data_1));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/complete_task.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_1 = curl_exec($ch);
$http_code_1 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_1 . "\n";
echo "Response: " . $response_1 . "\n\n";

// Test Case 2: Complete task without by_task (UNLIMITED)
echo "Test Case 2: Complete task without by_task parameter (UNLIMITED)\n";
$request_data_2 = [
    'user_id' => $user_id,
    'earned_coins' => 15
    // No by_task parameter = UNLIMITED
];

$encrypted_payload_2 = encryptToken(json_encode($request_data_2));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/complete_task.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_2);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_2 = curl_exec($ch);
$http_code_2 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_2 . "\n";
echo "Response: " . $response_2 . "\n\n";

// Test Case 3: Complete custom task (UNLIMITED - not in configured list)
echo "Test Case 3: Complete custom task (UNLIMITED - not in configured list)\n";
$request_data_3 = [
    'user_id' => $user_id,
    'earned_coins' => 20,
    'by_task' => 'custom_task' // Not in task_limits table = UNLIMITED
];

$encrypted_payload_3 = encryptToken(json_encode($request_data_3));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/complete_task.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_3);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_3 = curl_exec($ch);
$http_code_3 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_3 . "\n";
echo "Response: " . $response_3 . "\n\n";

// Test Case 4: Complete correct_spelling task (LIMITED)
echo "Test Case 4: Complete correct_spelling task (LIMITED)\n";
$request_data_4 = [
    'user_id' => $user_id,
    'earned_coins' => 15,
    'by_task' => 'correct_spelling'
];

$encrypted_payload_4 = encryptToken(json_encode($request_data_4));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/complete_task.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_4);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_4 = curl_exec($ch);
$http_code_4 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_4 . "\n";
echo "Response: " . $response_4 . "\n\n";

echo "=== Database Check ===\n";
// Check task limits configuration
$conn = getDbConnection();

// Check task_limits table
$stmt = $conn->prepare("SELECT task_type, daily_limit, is_enabled FROM task_limits");
$stmt->execute();
$result = $stmt->get_result();
echo "Task Limits Configuration:\n";
while ($row = $result->fetch_assoc()) {
    echo "- {$row['task_type']}: {$row['daily_limit']} per day (enabled: " . ($row['is_enabled'] ? 'Yes' : 'No') . ")\n";
}
$stmt->close();

// Check current user usage for today
$today = date('Y-m-d');
$stmt = $conn->prepare("SELECT task_type, used_count FROM user_task_usage WHERE user_id = ? AND usage_date = ?");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$result = $stmt->get_result();
echo "\nCurrent User Usage for Today ($today):\n";
while ($row = $result->fetch_assoc()) {
    echo "- {$row['task_type']}: {$row['used_count']} times used\n";
}
$stmt->close();

// Check app settings
$stmt = $conn->prepare("SELECT task_limits_enabled FROM app_settings WHERE id = 1");
$stmt->execute();
$result = $stmt->get_result();
$settings = $result->fetch_assoc();
$stmt->close();
echo "\nTask Limits Enabled in App Settings: " . ($settings['task_limits_enabled'] ? 'Yes' : 'No') . "\n";

$conn->close();

echo "\n=== Expected Response Formats ===\n";

echo "1. LIMITED Task (by_task provided and in configured list):\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task completed',
    'data' => [
        'show_ad' => true,
        'total_coins' => 1050,
        'task_limits' => [
            'enabled' => true,
            'remaining_limit' => 14, // Remaining attempts for today
            'daily_limit' => 20 // Total daily limit for this task type
        ],
        'referral_reward' => ['awarded' => false]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "2. UNLIMITED Task (no by_task parameter):\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task completed',
    'data' => [
        'show_ad' => true,
        'total_coins' => 1050,
        'task_limits' => [
            'enabled' => false,
            'remaining_limit' => null, // No limits applied
            'daily_limit' => null // No limits applied
        ],
        'referral_reward' => ['awarded' => false]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "3. UNLIMITED Task (by_task not in configured list):\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task completed',
    'data' => [
        'show_ad' => true,
        'total_coins' => 1050,
        'task_limits' => [
            'enabled' => false,
            'remaining_limit' => null, // No limits applied
            'daily_limit' => null // No limits applied
        ],
        'referral_reward' => ['awarded' => false]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "=== Usage Examples ===\n";
echo "1. LIMITED Task (by_task provided):\n";
echo json_encode($request_data_1, JSON_PRETTY_PRINT) . "\n\n";

echo "2. UNLIMITED Task (no by_task):\n";
echo json_encode($request_data_2, JSON_PRETTY_PRINT) . "\n\n";

echo "3. UNLIMITED Task (custom by_task):\n";
echo json_encode($request_data_3, JSON_PRETTY_PRINT) . "\n\n";

echo "=== Key Points ===\n";
echo "✅ Tasks WITHOUT by_task parameter = UNLIMITED (no tracking)\n";
echo "✅ Tasks WITH by_task NOT in configured list = UNLIMITED (no tracking)\n";
echo "✅ Tasks WITH by_task in configured list = LIMITED (tracked)\n";
echo "✅ Backward compatible - existing apps continue to work\n";
echo "✅ Daily limits reset at midnight\n";
echo "✅ Can be enabled/disabled globally in app settings\n";
?> 