<?php
require_once 'config.php';

header('Content-Type: application/json');

$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
if ($limit <= 0 || $limit > 100) {
    $limit = 20;
}

$conn = getDbConnection();
$stmt = $conn->prepare("SELECT image_url FROM count_images_image_list ORDER BY RAND() LIMIT ?");
$stmt->bind_param("i", $limit);
$stmt->execute();
$result = $stmt->get_result();

$images = [];
while ($row = $result->fetch_assoc()) {
    $images[] = $row['image_url'];
}

$stmt->close();
$conn->close();

if (empty($images)) {
    echo json_encode([
        'status' => 404,
        'message' => 'No images found',
        'images' => []
    ]);
    exit;
}

echo json_encode([
    'status' => 200,
    'message' => 'Images fetched',
    'images' => $images
]); 