<?php
// Test script for daily_checkin endpoint with earned_coins parameter
require_once 'config.php';

// Test data
$user_id = 1; // Replace with actual user ID
$device_id = 'test_device_123'; // Replace with actual device ID
$session_token = 'test_session_token'; // Replace with actual session token

echo "=== Testing daily_checkin.php with earned_coins parameter ===\n\n";

// Test Case 1: Using earned_coins parameter (app specifies reward)
echo "Test Case 1: Using earned_coins parameter\n";
$request_data_1 = [
    'user_id' => $user_id,
    'earned_coins' => 75 // App specifies user earned 75 coins
];

$encrypted_payload_1 = encryptToken(json_encode($request_data_1));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/daily_checkin.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_1 = curl_exec($ch);
$http_code_1 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_1 . "\n";
echo "Response: " . $response_1 . "\n\n";

// Test Case 2: Without earned_coins parameter (uses app settings)
echo "Test Case 2: Without earned_coins parameter (uses app settings)\n";
$request_data_2 = [
    'user_id' => $user_id
    // No earned_coins - will use app settings
];

$encrypted_payload_2 = encryptToken(json_encode($request_data_2));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/daily_checkin.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_2);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_2 = curl_exec($ch);
$http_code_2 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_2 . "\n";
echo "Response: " . $response_2 . "\n\n";

// Test Case 3: Invalid earned_coins value
echo "Test Case 3: Invalid earned_coins value (negative)\n";
$request_data_3 = [
    'user_id' => $user_id,
    'earned_coins' => -10 // Invalid negative value
];

$encrypted_payload_3 = encryptToken(json_encode($request_data_3));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/daily_checkin.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_3);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_3 = curl_exec($ch);
$http_code_3 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_3 . "\n";
echo "Response: " . $response_3 . "\n\n";

echo "=== Usage Examples ===\n\n";

echo "1. App specifies earned coins:\n";
echo "Request Body:\n";
echo json_encode($request_data_1, JSON_PRETTY_PRINT) . "\n\n";

echo "2. Use app settings (existing behavior):\n";
echo "Request Body:\n";
echo json_encode($request_data_2, JSON_PRETTY_PRINT) . "\n\n";

echo "=== Benefits ===\n";
echo "- App can calculate dynamic rewards based on user behavior\n";
echo "- App can implement bonus systems (streak bonuses, special events)\n";
echo "- App can adjust rewards based on user level or achievements\n";
echo "- Backward compatible - existing apps continue to work\n";
echo "- No changes to database schema required\n";
?> 