<?php
// Test script for task_limits endpoint
require_once 'config.php';

// Test data
$user_id = 1; // Replace with actual user ID
$device_id = 'test_device_123'; // Replace with actual device ID
$session_token = 'test_session_token'; // Replace with actual session token

echo "=== Testing task_limits.php endpoint ===\n\n";

// Test Case 1: Check all task limits
echo "Test Case 1: Check all task limits\n";
$request_data_1 = [
    'user_id' => $user_id
    // No task_type = get all limits
];

$encrypted_payload_1 = encryptToken(json_encode($request_data_1));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/task_limits.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_1 = curl_exec($ch);
$http_code_1 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_1 . "\n";
echo "Response: " . $response_1 . "\n\n";

// Test Case 2: Check specific task type (quiz)
echo "Test Case 2: Check specific task type (quiz)\n";
$request_data_2 = [
    'user_id' => $user_id,
    'task_type' => 'quiz'
];

$encrypted_payload_2 = encryptToken(json_encode($request_data_2));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/task_limits.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_2);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_2 = curl_exec($ch);
$http_code_2 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_2 . "\n";
echo "Response: " . $response_2 . "\n\n";

// Test Case 3: Check non-existent task type
echo "Test Case 3: Check non-existent task type\n";
$request_data_3 = [
    'user_id' => $user_id,
    'task_type' => 'custom_task'
];

$encrypted_payload_3 = encryptToken(json_encode($request_data_3));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/task_limits.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_3);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_3 = curl_exec($ch);
$http_code_3 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_3 . "\n";
echo "Response: " . $response_3 . "\n\n";

// Test Case 4: Check correct_spelling task
echo "Test Case 4: Check correct_spelling task\n";
$request_data_4 = [
    'user_id' => $user_id,
    'task_type' => 'correct_spelling'
];

$encrypted_payload_4 = encryptToken(json_encode($request_data_4));

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/api/user/task_limits.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload_4);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response_4 = curl_exec($ch);
$http_code_4 = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: " . $http_code_4 . "\n";
echo "Response: " . $response_4 . "\n\n";

echo "=== Database Check ===\n";
// Check current configuration and usage
$conn = getDbConnection();

// Check app settings
$stmt = $conn->prepare("SELECT task_limits_enabled FROM app_settings WHERE id = 1");
$stmt->execute();
$result = $stmt->get_result();
$settings = $result->fetch_assoc();
$stmt->close();
echo "Task Limits Enabled: " . ($settings['task_limits_enabled'] ? 'Yes' : 'No') . "\n\n";

// Check task limits configuration
$stmt = $conn->prepare("SELECT task_type, daily_limit, is_enabled FROM task_limits ORDER BY task_type");
$stmt->execute();
$result = $stmt->get_result();
echo "Task Limits Configuration:\n";
while ($row = $result->fetch_assoc()) {
    echo "- {$row['task_type']}: {$row['daily_limit']} per day (enabled: " . ($row['is_enabled'] ? 'Yes' : 'No') . ")\n";
}
$stmt->close();

// Check current user usage for today
$today = date('Y-m-d');
$stmt = $conn->prepare("SELECT task_type, used_count FROM user_task_usage WHERE user_id = ? AND usage_date = ? ORDER BY task_type");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$result = $stmt->get_result();
echo "\nCurrent User Usage for Today ($today):\n";
while ($row = $result->fetch_assoc()) {
    echo "- {$row['task_type']}: {$row['used_count']} times used\n";
}
$stmt->close();

$conn->close();

echo "\n=== Expected Response Formats ===\n";

echo "1. All Task Limits:\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task limits fetched',
    'data' => [
        'enabled' => true,
        'limits' => [
            [
                'task_type' => 'quiz',
                'daily_limit' => 20,
                'used_count' => 5,
                'remaining_limit' => 15
            ],
            [
                'task_type' => 'correct_spelling',
                'daily_limit' => 15,
                'used_count' => 3,
                'remaining_limit' => 12
            ],
            [
                'task_type' => 'image_puzzle',
                'daily_limit' => 10,
                'used_count' => 2,
                'remaining_limit' => 8
            ]
        ]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "2. Specific Task Limit:\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task limits fetched',
    'data' => [
        'enabled' => true,
        'limits' => [
            [
                'task_type' => 'quiz',
                'daily_limit' => 20,
                'used_count' => 5,
                'remaining_limit' => 15
            ]
        ]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "3. Non-existent Task Type:\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task limits fetched',
    'data' => [
        'enabled' => true,
        'limits' => [
            [
                'task_type' => 'custom_task',
                'daily_limit' => null,
                'used_count' => 0,
                'remaining_limit' => null,
                'note' => 'Task type not limited'
            ]
        ]
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "4. Task Limits Disabled:\n";
echo json_encode([
    'status' => 200,
    'message' => 'Task limits fetched',
    'data' => [
        'enabled' => false,
        'limits' => []
    ],
    'new_session_token' => 'new_token_here'
], JSON_PRETTY_PRINT) . "\n\n";

echo "=== Usage Examples ===\n";
echo "1. Check all task limits:\n";
echo json_encode($request_data_1, JSON_PRETTY_PRINT) . "\n\n";

echo "2. Check specific task limit:\n";
echo json_encode($request_data_2, JSON_PRETTY_PRINT) . "\n\n";

echo "3. Check non-existent task:\n";
echo json_encode($request_data_3, JSON_PRETTY_PRINT) . "\n\n";

echo "=== Benefits ===\n";
echo "- Check limits before attempting tasks\n";
echo "- Show remaining attempts in UI\n";
echo "- Prevent failed task completions\n";
echo "- Better user experience\n";
echo "- Real-time limit information\n";
echo "- Works with specific or all task types\n";
?> 