<?php
// Test script for checkin_status endpoint
require_once 'config.php';

// Test data
$user_id = 1; // Replace with actual user ID
$device_id = 'test_device_123'; // Replace with actual device ID
$session_token = 'test_session_token'; // Replace with actual session token

// Prepare request data
$request_data = [
    'user_id' => $user_id
];

// Encrypt the request payload
$encrypted_payload = encryptToken(json_encode($request_data));

// Set up cURL request
$url = 'http://localhost/api/user/checkin_status.php'; // Adjust URL as needed

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $encrypted_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Device-ID: ' . $device_id,
    'Session-Token: ' . $session_token,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_HEADER, true);

// Execute the request
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "=== Test Results for checkin_status.php ===\n";
echo "HTTP Code: " . $http_code . "\n";
echo "cURL Error: " . ($error ?: 'None') . "\n";
echo "Raw Response:\n" . $response . "\n\n";

if ($response && !$error) {
    // Split headers and body
    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $headers = substr($response, 0, $header_size);
    $body = substr($response, $header_size);
    
    echo "Headers:\n" . $headers . "\n";
    echo "Encrypted Body:\n" . $body . "\n\n";
    
    // Try to decrypt the response
    try {
        $decrypted_response = decryptToken($body);
        echo "Decrypted Response:\n" . $decrypted_response . "\n\n";
        
        $json_data = json_decode($decrypted_response, true);
        if ($json_data) {
            echo "Parsed JSON:\n";
            print_r($json_data);
        } else {
            echo "Failed to parse JSON: " . json_last_error_msg() . "\n";
        }
    } catch (Exception $e) {
        echo "Failed to decrypt response: " . $e->getMessage() . "\n";
    }
}

echo "\n=== Database Check ===\n";
// Check if required tables and columns exist
$conn = getDbConnection();

// Check app_settings table
$stmt = $conn->prepare("SHOW TABLES LIKE 'app_settings'");
$stmt->execute();
$result = $stmt->get_result();
echo "app_settings table exists: " . ($result->num_rows > 0 ? 'Yes' : 'No') . "\n";

// Check daily_checkin_coins column
$stmt = $conn->prepare("SHOW COLUMNS FROM app_settings LIKE 'daily_checkin_coins'");
$stmt->execute();
$result = $stmt->get_result();
echo "daily_checkin_coins column exists: " . ($result->num_rows > 0 ? 'Yes' : 'No') . "\n";

// Check daily_checkins table
$stmt = $conn->prepare("SHOW TABLES LIKE 'daily_checkins'");
$stmt->execute();
$result = $stmt->get_result();
echo "daily_checkins table exists: " . ($result->num_rows > 0 ? 'Yes' : 'No') . "\n";

// Check users table
$stmt = $conn->prepare("SHOW TABLES LIKE 'users'");
$stmt->execute();
$result = $stmt->get_result();
echo "users table exists: " . ($result->num_rows > 0 ? 'Yes' : 'No') . "\n";

// Check if test user exists
$stmt = $conn->prepare("SELECT id, device_id FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
echo "Test user exists: " . ($user ? 'Yes (Device ID: ' . $user['device_id'] . ')' : 'No') . "\n";

$conn->close();
?> 